# Tested with 2 & 4 GPUs
eval "$(conda shell.bash hook)"
conda activate reil || exit 1

set -x

# Shift the arguments so $@ refers to the rest
shift 2
N_GPUS=4

BASE_MODEL="./models/rlft/models--Qwen--Qwen2.5-1.5B/snapshots/8faed761d45a263340a0528343f099c05c9a4323"
# DATA_DIR="./data/alfworld_task_type/sft"
# EXPERIMENT_NAME="alfworld-1.5b-pick_n_place-sft-lora-32-$(date +%m-%d)"
DATA_DIR="./data/sokoban_one_horizon_large_envs/sft"
EXPERIMENT_NAME="sokoban-1.5b-sft-lora-32-$(date +%m-%d)"

torchrun --standalone --nnodes=1 --nproc_per_node=$N_GPUS \
     -m reil.trainer.fsdp_sft_trainer \
    data.train_files=$DATA_DIR/train.parquet \
    data.val_files=$DATA_DIR/test.parquet \
    data.prompt_key=prompt \
    data.response_key=response \
    data.max_length=2048 \
    data.train_batch_size=256 \
    optim.lr=1e-4 \
    data.micro_batch_size_per_gpu=16 \
    model.partial_pretrain=$BASE_MODEL \
    model.fsdp_config.cpu_offload=True \
    ulysses_sequence_parallel_size=2 \
    use_remove_padding=True \
    model.enable_gradient_checkpointing=True \
    trainer.project_name=REIL-sft \
    trainer.experiment_name=$EXPERIMENT_NAME \
    trainer.default_local_dir=checkpoints/ds543/sft/$EXPERIMENT_NAME \
    trainer.logger="['console', 'wandb']" \
    trainer.total_epochs=30 \
    trainer.default_hdfs_dir=null $@ \
    trainer.policy_eval=True \
    es_manager.val.env_groups=512 \
    es_manager.val.group_size=1 \
    es_manager.val.env_configs.tags="['LargerSokoban','SimpleSokoban']" \
    es_manager.val.env_configs.n_groups="[256,256]" \
    model.lora_rank=32\
    model.lora_alpha=16 \
    model.target_modules=all-linear 2>&1 | tee checkpoints/ds543/sft/${EXPERIMENT_NAME}_train.log

    # Or you can do this:
    # model.target_modules=[q_proj,v_proj] \